﻿using Helper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using ZSMusic.IDAL;
using ZSMusic.Model;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace ZSMusic.DAL.Platforms
{
    public class mg : IMusic
    {
        public List<Music> Search(string word, int page, int num)
        {
            List<Music> list = new List<Music>();
            string src = HttpHelper.Get(string.Format(
            "http://iecoxe.top:5000/v1/migu/search?key={0}&offset={1}&limit={2}"
            ,  page, word,num));
            JObject jobject = JObject.Parse(src);
            foreach (JToken item in ((IEnumerable<JToken>)jobject["musics"]))
            {
                Music m = new Music() {
                    Id = item["copyrightId"].ToString(),
                    Name = item["songName"].ToString(),
                    Artist = item["singerName"].ToString(),
                    Album = item["albumName"].ToString(),
                    AlbumId = item["albumId"].ToString(),
                    Source="mg",
                    Tag = item["albumId"].ToString()
                };
                m.ToString();
                list.Add(m);
            }
            return list;
        }

        public List<Music> SearchCollection(string id)
        {
            throw new NotImplementedException("该平台暂未支持歌单解析");
        }

        public List<Music> SearchAlbum(string id)
        {
            throw new NotImplementedException("该平台暂未支持专辑解析");
        }

        public bool GetData(Music m, string type = "all")
        {
            switch (type)
            {
                case "all":
                    GetPic(m);
                    GetLrc(m);
                    return GetUrl(m);
                case "url":
                    return GetUrl(m);
                case "pic":
                    return GetPic(m);
                case "lrc":
                    return GetLrc(m);
                default:
                    throw new NotImplementedException();
            }
        }

        private bool GetUrl(Music m)
        {
            m.Url = HttpHelper.Redirect(string.Format("https://myhkw.cn/api/musicUrl?songId={0}&type=mg&id=155782152289",m.Id));
            return HttpHelper.CheckUri(m.Url);
        }

        private bool GetLrc(Music m)
        {
            string Lrcsrc = HttpHelper.Get(string.Format(
            "https://myhkw.cn/api/musicLyric?callback=jQuery1113031861012363350283_1625019762672&type=mg&songId={0}&id=myhkwebplayer&_=1625019762683"
            , m.Id));
            m.Lrc = StringEx.GetMiddleText(Lrcsrc, "lyric\":\"", "\",\"name").Trim()
            .Replace("\\n", "\n").Replace("\\r", "");
            return !string.IsNullOrWhiteSpace(m.Lrc);
        }

        private bool GetPic(Music m)
        {
            if (m.AlbumId.Contains("http")) { m.PicUrl = m.AlbumId; }
            else
            {
                m.PicUrl = HttpHelper.Redirect(string.Format("https://myhkw.cn/api/musicPic?picId={0}&type=mg&size=big",m.AlbumId));
            }
            return HttpHelper.CheckUri(m.PicUrl);
        }


    }
}
